/*
 * Decompiled with CFR 0.152.
 */
package com.timpatton.jcat;

public class CueCatCode {
    public static final int BARCODE_UNKNOWN = 0;
    public static final int BARCODE_UPC_E = 1;
    public static final int BARCODE_UPC_A = 2;
    public static final int BARCODE_UPC_A_ADD2 = 3;
    public static final int BARCODE_ISBN = 4;
    public static final int BARCODE_ISBN_ADD5 = 5;
    public static final int BARCODE_EAN_8 = 6;
    public static final int BARCODE_EAN_13 = 7;
    public static final int BARCODE_CODE128 = 8;
    public static final int BARCODE_CODE128_B = 9;
    public static final int BARCODE_CODE128_C = 10;
    public static final int BARCODE_CODE39 = 11;
    public static final int BARCODE_INTERLEAVED_2OF5 = 12;
    public static final int BARCODE_ITF_6 = 13;
    public static final int BARCODE_CUE = 14;
    public static final int BARCODE_EAN_13_ADD2 = 15;
    public static final int BARCODE_EAN_13_ADD5 = 16;
    public static final int BARCODE_EAN_128 = 17;
    public static final int BARCODE_EXTENDED_CODE39 = 18;
    public static final int BARCODE_CODE93 = 19;
    public static final int BARCODE_2OF5 = 20;
    public static final int BARCODE_MSI = 21;
    public static final int BARCODE_POSTNET = 22;
    public static final int BARCODE_RM4SCC = 23;
    public static final int BARCODE_4STATE = 24;
    public static final int BARCODE_SISAC = 25;
    public static final String[] barTypeStrings = new String[]{null, "UPE", "UPA", "UP2", "IBN", "IB5", "E08", "E13", "128", "128", "128", "C39", "ITF", "ITF", "CC!", null, null, null, null, null, null, null, null, null, null, null};
    public static final String[] barTypePrintable = new String[]{"Unknown", "UPC-E", "UPC-A", "UPC-A, add 2", "ISBN", "ISBN, add 5", "EAN-8", "EAN-13", "CODE128", "CODE128-B", "CODE128-C", "CODE39", "Interleaved 2 of 5", "ITF-6", "Cue", "EAN-13, add 2", "EAN-13, add 5", "EAN-128", "Extended CODE39", "2 of 5", "MSI", "PostNet", "RM4SCC", "4-State", "SISAC"};
    public String cueCatID;
    public int barType;
    public String barTypeStr;
    public String barCode;

    public CueCatCode(String cueCatID, String barTypeStr, String barCode) {
        this.cueCatID = cueCatID;
        this.barType = CueCatCode.getBarType(barTypeStr);
        this.barTypeStr = CueCatCode.getPrintableType(this.barType);
        this.barCode = CueCatCode.processCode(this.barType, barCode);
    }

    public static int getBarType(String barString) {
        int i = 0;
        while (i < barTypeStrings.length) {
            if (barString.equals(barTypeStrings[i])) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static String getPrintableType(int barType) {
        return barTypePrintable[barType];
    }

    private static String processCode(int type, String code) {
        if (type == 4 || type == 5) {
            return CueCatCode.getISBNfromUPC(code);
        }
        if (type == 1) {
            return code;
        }
        return code;
    }

    public static String getISBNfromUPC(String upc) {
        StringBuffer isbn = new StringBuffer(upc);
        if (upc.indexOf("978") == 0) {
            isbn = new StringBuffer(upc.substring(3, 12));
            int xsum = 0;
            int add = 0;
            int i = 0;
            while (i < 9) {
                String temp = isbn.substring(i, i + 1);
                add = Integer.parseInt(temp);
                xsum += (10 - i) * add;
                ++i;
            }
            xsum %= 11;
            if ((xsum = 11 - xsum) == 10) {
                isbn.append("X");
            } else if (xsum == 11) {
                isbn.append("0");
            } else {
                isbn.append(xsum);
            }
        }
        return isbn.toString();
    }
}

