/*
 * Decompiled with CFR 0.152.
 */
package com.timpatton.jcat;

import com.timpatton.jcat.CueCatCode;
import java.util.StringTokenizer;
import starlight.util.Base64;

public class CueCatDecoder {
    public static String decodeToken(String encoded) {
        char[] chars = CueCatDecoder.padInput(encoded);
        CueCatDecoder.swapUpperLower(chars);
        byte[] decode_bytes = Base64.decode(chars);
        int i = 0;
        while (i < decode_bytes.length) {
            decode_bytes[i] = (byte)(decode_bytes[i] ^ 0x43);
            ++i;
        }
        return new String(decode_bytes);
    }

    public static void swapUpperLower(char[] chars) {
        int diff = 32;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] >= 'a' && chars[i] <= 'z') {
                chars[i] = (char)(chars[i] - diff);
            } else if (chars[i] >= 'A' && chars[i] <= 'Z') {
                chars[i] = (char)(chars[i] + diff);
            } else if (chars[i] == '-') {
                chars[i] = 47;
            }
            ++i;
        }
    }

    public static CueCatCode decodeLine(String s) {
        StringTokenizer st = new StringTokenizer(s, ".");
        int count = 0;
        String cueCode = null;
        String barCode = null;
        String barType = null;
        while (st.hasMoreTokens() && count < 3) {
            String token = st.nextToken();
            String temp = CueCatDecoder.decodeToken(token);
            if (count == 0) {
                cueCode = temp;
            } else if (count == 1) {
                barType = temp;
            } else if (count == 2) {
                barCode = temp;
            }
            ++count;
        }
        if (count < 2) {
            return null;
        }
        return new CueCatCode(cueCode, barType, barCode);
    }

    public static char[] padInput(String encoded) {
        char[] chars;
        if (encoded.length() % 4 != 0) {
            int new_len = (encoded.length() + 3) / 4 * 4;
            chars = new char[new_len];
            encoded.getChars(0, encoded.length(), chars, 0);
            int i = encoded.length();
            while (i < chars.length) {
                chars[i] = 61;
                ++i;
            }
        } else {
            chars = encoded.toCharArray();
        }
        return chars;
    }
}

