/*
 * Decompiled with CFR 0.152.
 */
package com.timpatton.jcat;

import com.timpatton.jcat.CueCatCode;
import com.timpatton.jcat.CueCatDecoder;
import com.timpatton.jcat.CueCatURL;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class JCatFrame
extends JFrame {
    private JTextField cueCatInput;
    private JTextField cueCatIDT;
    private JTextField typeT;
    private JTextField barCodeT;
    private JCheckBox autoLaunchCB;
    private boolean autoLaunch;
    private CueCatCode lastCode = null;

    public JCatFrame() {
        super("JCat");
        JButton button = new JButton("Decode");
        button.setFont(new Font("SansSerif", 1, 14));
        JButton launch = new JButton("Launch Browser");
        launch.setFont(new Font("SansSerif", 1, 14));
        this.autoLaunchCB = new JCheckBox("Auto-Launch Browser", true);
        this.autoLaunch = true;
        this.autoLaunchCB.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    JCatFrame.this.autoLaunch = false;
                } else {
                    JCatFrame.this.autoLaunch = true;
                }
            }
        });
        JPanel temp = new JPanel();
        temp.add(button);
        temp.add(launch);
        temp.add(this.autoLaunchCB);
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)temp, "South");
        this.cueCatInput = new JTextField(50);
        JLabel cueCatL = new JLabel("CueCat Scan:  ");
        Box b = Box.createHorizontalBox();
        b.add(cueCatL);
        b.add(this.cueCatInput);
        b.add(Box.createHorizontalGlue());
        pane.add((Component)b, "North");
        JLabel cueCatIDL = new JLabel("CueCatID:  ");
        this.cueCatIDT = new JTextField(15);
        JLabel typeL = new JLabel("Type:  ");
        this.typeT = new JTextField(5);
        JLabel barCodeL = new JLabel("Data:  ");
        this.barCodeT = new JTextField(20);
        b = Box.createHorizontalBox();
        b.add(cueCatIDL);
        b.add(this.cueCatIDT);
        b.add(Box.createHorizontalGlue());
        Box b2 = Box.createHorizontalBox();
        b2.add(typeL);
        b2.add(this.typeT);
        b2.add(Box.createHorizontalGlue());
        Box b3 = Box.createHorizontalBox();
        b3.add(barCodeL);
        b3.add(this.barCodeT);
        b3.add(Box.createHorizontalGlue());
        Box b4 = Box.createVerticalBox();
        b4.add(Box.createVerticalStrut(20));
        b4.add(b);
        b4.add(b2);
        b4.add(b3);
        pane.add((Component)b4, "Center");
        launch.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCatFrame.this.cueCatInput.setText("");
                JCatFrame.this.cueCatInput.requestFocus();
            }
        }, KeyStroke.getKeyStroke(121, 0), 2);
        launch.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCatFrame.this.decode();
            }
        }, KeyStroke.getKeyStroke(10, 0), 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JCatFrame.this.windowClosed();
            }
        });
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCatFrame.this.decode();
            }
        });
        launch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCatFrame.this.launchBrowser();
            }
        });
    }

    private void decode() {
        String cueCatText = this.cueCatInput.getText();
        CueCatCode ccc = CueCatDecoder.decodeLine(cueCatText);
        this.cueCatIDT.setText(ccc.cueCatID);
        this.typeT.setText(ccc.barTypeStr);
        this.barCodeT.setText(ccc.barCode);
        this.lastCode = ccc;
        if (this.autoLaunch) {
            this.launchBrowser();
        }
    }

    private void launchBrowser() {
        String url = CueCatURL.getRelatedURL(this.lastCode);
        if (url != null) {
            try {
                BrowserLauncher.openURL(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void windowClosed() {
        System.exit(0);
    }

    public void show() {
        super.show();
        this.cueCatInput.requestFocus();
    }
}

