#ifndef _KERNEL_WRAPPERS_H_
#define _KERNEL_WRAPPERS_H_

/***************************************************************************
 *
 * kernel_wrappers.h
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux
 * Copyright (c) 1999, 2000, 2001, 2002 Networks Associates
 * Technology, Inc.  All rights reserved.
 * 
 * This file is part of LOMAC.
 *
 * LOMAC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * LOMAC is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOMAC; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 *
 *
 *
 ***************************************************************************/


#include <linux/types.h>    /* for pid_t */

#include "kernel_intercept.h"

SETUP_SYSCALL_STORAGE(open);
SETUP_SYSCALL_STORAGE(read);
SETUP_SYSCALL_STORAGE(readv);
SETUP_SYSCALL_STORAGE(write);
SETUP_SYSCALL_STORAGE(writev);
SETUP_SYSCALL_STORAGE(pipe);
SETUP_SYSCALL_STORAGE(mknod);
SETUP_SYSCALL_STORAGE(truncate);
SETUP_SYSCALL_STORAGE(ftruncate);
SETUP_SYSCALL_STORAGE(unlink);
SETUP_SYSCALL_STORAGE(rename);
SETUP_SYSCALL_STORAGE(link);
SETUP_SYSCALL_STORAGE(socketcall);
SETUP_SYSCALL_STORAGE(kill);
SETUP_SYSCALL_STORAGE(mkdir);
SETUP_SYSCALL_STORAGE(rmdir);
SETUP_SYSCALL_STORAGE(mount);
SETUP_SYSCALL_STORAGE(umount);
SETUP_SYSCALL_STORAGE(reboot);
SETUP_SYSCALL_STORAGE(create_module);
SETUP_SYSCALL_STORAGE(init_module);
SETUP_SYSCALL_STORAGE(delete_module);


int wrap_open( const char *filename, int flags, int mode );
int wrap_read( unsigned int fd, char *buf, int count );
int wrap_readv( unsigned long fd, const struct iovec *vector, long count );
int wrap_write( unsigned int fd, char *buf, unsigned int count );
int wrap_writev( unsigned long fd, const struct iovec *vector, long count );
int wrap_pipe( unsigned long *fildes );
int wrap_mknod( const char *filename, int mode, dev_t dev );
int wrap_truncate( const char *path, unsigned long length );
int wrap_ftruncate( unsigned int fd, unsigned long length );
int wrap_unlink( const char *pathname );
int wrap_rename( const char *oldname, const char *newname );
int wrap_link( const char *oldname, const char *newname);
int wrap_socketcall( int call, unsigned long *args );
int wrap_kill( int pid, int sig );
int wrap_mkdir( const char *pathname, int mode );
int wrap_rmdir( const char *pathname );
int wrap_mount( char *dev_name, char *dir_name, char *type,
		unsigned long new_flags, void *data );
int wrap_umount( char *name, int flags );
int wrap_reboot( int magic1, int magic2, int cmd, void *arg );
int wrap_create_module( const char *name_user, size_t size );
int wrap_init_module( const char *name_user, struct module *mod_user );
int wrap_delete_module( const char *name_user );

#endif
