#ifndef _POLICY_PLM_H_
#define _POLICY_PLM_H_

/*************************************************************************
 *
 * policy_plm.h
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux
 * Copyright (c) 1999, 2000, 2001, 2002 Networks Associates
 * Technology, Inc.  All rights reserved.
 * 
 * This file is part of LOMAC.
 *
 * LOMAC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * LOMAC is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOMAC; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 *
 * This file defines the PLM part of LOMAC's security policy configuration.
 * This configuration has two parts:
 * 1.  The Path-Level Map (PLM) - this data structure indicates
 *     which parts of the filesystem are at which level.
 * 2.  The Trusted Program List (TPL) - this data structure
 *     lists which programs LOMAC trusts with the ability
 *     to avoid demotion.
 *
 * Since filesystem layout and programs vary between
 * architectures, this configuration is architecture-
 * dependent.
 *
 *************************************************************************/

#include "lomac_attr.h"

typedef struct plm_rule {
  lattr_t lattr;       /* LOMAC attributes */
  int     flags;       /* flags for PLM evaluation */
  char   *path_s;      /* canabspath for this PLM rule */
} plm_rule_t;

#define PLM_NOFLAGS 0x00 /* rule applies to this node and its children */
#define PLM_CHILDOF 0x01 /* rule applies to node's children, not the node */

/* The `plm' array maps levels onto all of the files in the filesystem */
#define HIGH { LOMAC_HIGHEST_LEVEL, 0, 0 }
#define LOW  { LOMAC_LOWEST_LEVEL, 0, 0 }


#define NUM_PLM_RULES 29
plm_rule_t plm[ NUM_PLM_RULES ] = {
  { LOW,  PLM_NOFLAGS, "/var/run/ftp.pids-all" },
  { HIGH, PLM_NOFLAGS, "/var/log/messages" },
  { HIGH, PLM_NOFLAGS, "/var/lib/debconf" },
  { HIGH, PLM_NOFLAGS, "/var/log/faillog" },
  { HIGH, PLM_NOFLAGS, "/var/log/lastlog" },
  { HIGH, PLM_NOFLAGS, "/var/lib/pcmcia" },
  { HIGH, PLM_NOFLAGS, "/var/log/secure" },
  { HIGH, PLM_NOFLAGS, "/var/lib/dpkg" },
  { LOW,  PLM_NOFLAGS, "/dev/printer" },
  { HIGH, PLM_NOFLAGS, "/var/lib/nfs" },
  { HIGH, PLM_NOFLAGS, "/var/lib/rpm" },
  { HIGH, PLM_NOFLAGS, "/home/httpd" },
  { HIGH, PLM_NOFLAGS, "/home/samba" },
  { HIGH, PLM_NOFLAGS, "/mnt/cdrom" },  /* cdrom is high */
  { LOW,  PLM_CHILDOF, "/usr/local" }, /* dwnlded progs here */
  { HIGH, PLM_NOFLAGS, "/home/ftp" },
  { LOW,  PLM_NOFLAGS, "/dev/log" },
  { LOW,  PLM_NOFLAGS, "/usr/src" },
  { LOW,  PLM_NOFLAGS, "/usr/tmp" },
  { LOW,  PLM_CHILDOF, "/var/lib" },
  { HIGH, PLM_NOFLAGS, "/var/lib" },
  { LOW,  PLM_CHILDOF, "/var/log" },
  { HIGH, PLM_NOFLAGS, "/var/log" },
  { HIGH, PLM_NOFLAGS, "/var/run" },
  { LOW,  PLM_CHILDOF, "/home" }, 
  { LOW,  PLM_CHILDOF, "/mnt" },  /* all nfs mounts are low */
  { LOW,  PLM_NOFLAGS, "/tmp" },
  { LOW,  PLM_CHILDOF, "/var" },
  { HIGH, PLM_NOFLAGS, "/" }
};

#endif
