#ifndef _POLICY_TPL_H_
#define _POLICY_TPL_H_

/*************************************************************************
 *
 * policy_tpl.h
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux
 * Copyright (c) 1999, 2000, 2001, 2002 Networks Associates
 * Technology, Inc.  All rights reserved.
 * 
 * This file is part of LOMAC.
 *
 * LOMAC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * LOMAC is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOMAC; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 *
 * This file defines the TPL part of LOMAC's security policy configuration.
 * This configuration has two parts:
 * 1.  The Path-Level Map (PLM) - this data structure indicates
 *     which parts of the filesystem are at which level.
 * 2.  The Trusted Program List (TPL) - this data structure
 *     lists which programs LOMAC trusts with the ability
 *     to avoid demotion.
 *
 * Since filesystem layout and programs vary between
 * architectures, this configuration is architecture-
 * dependent.
 *
 *************************************************************************/

#define NUM_TPL_ENTRIES 11
char *tpl[ NUM_TPL_ENTRIES ] = {
  "/usr/bin/dpkg-deb",     /* trying to get apt-get to work ## */
  "/usr/bin/dpkg",         /* trying to get apt-get to work ## */
  "/usr/bin/apt-get",      /* trying to get apt-get to work ## */
  "/usr/sbin/syslogd",     /* the main system log daemon, RH6.0 */
  "/sbin/syslogd",         /* the main system log daemon, RH 6.1 */
  "/sbin/minilogd",        /* a log daemon for early runlevels */
  "/bin/mount",            /* so we can mount NFS despite required net read */
  "/usr/sbin/sshd",        /* so administrators can log in remotely... ugh. */
  "/sbin/cardmgr",         /* laptop: avoid tmp-related demotion for pump */
  "/sbin/pump",            /* laptop: pump is client-side DHCP agent */
  "/opt/lomac/bin/lup"     /* LOMAC's trusted upgrade program */
};

#endif
