#ifndef _LOMAC_ATTR_H_
#define _LOMAC_ATTR_H_

/*************************************************************************
 *
 * lomac_attr.h
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux
 * Copyright (c) 1999, 2000, 2001, 2002 Networks Associates
 * Technology, Inc.  All rights reserved.
 * 
 * This file is part of LOMAC.
 *
 * LOMAC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * LOMAC is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOMAC; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 * This is the public interface for the LOMAC attribute (lattr_t) ADT.
 *
 * LOMAC assigns attributes to all subjects and objects.  Architecture-
 * specific interfaces may store subject and object attributes in
 * different ways.  However, when the architecture-independent LOMAC
 * core manipulates attributes, it does so using this common format.
 *
 * Only subjects use the `trust' field.
 *
 *************************************************************************/

typedef struct {
  int level;        /* level (an integer range) */
  int categories;   /* category flags */
  int trust;        /* trust flags (meaningful for subjects only) */
} lattr_t;          /* lomac attribute structure type */


/* Constants for lattr_t's `level' field */
#define LOMAC_INVALID_LEVEL  0
#define LOMAC_LOWEST_LEVEL   1
#define LOMAC_HIGHEST_LEVEL  2

#define LEVEL_LEQ( a, b )( (a) <= (b) )

/* Constants for lattr_t's `categories' field */
#define LOMAC_CATEGORY_NONE  0x00000000
#define LOMAC_CATEGORY_ONE   0x00000010
#define LOMAC_CATEGORY_TWO   0x00000020
#define LOMAC_CATEGORY_THREE 0x00000040
#define LOMAC_CATEGORY_FOUR  0x00000080

/* Constants for lattr_t's `trust' field */
#define LOMAC_TRUST_NONE      0x00000000
#define LOMAC_TRUST_NODEMOTE  0x00000001

#define LATTR_HIGH    ((lattr_t){ LOMAC_HIGHEST_LEVEL, 0, 0 })
#define LATTR_LOW     ((lattr_t){ LOMAC_LOWEST_LEVEL,  0, 0 })
#define LATTR_INVALID ((lattr_t){ LOMAC_INVALID_LEVEL, 0, 0 })

#endif
