#ifndef _LOMAC_MEDIATE_H_
#define _LOMAC_MEDIATE_H_

/*************************************************************************
 *
 * lomac_mediate.h
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux
 * Copyright (c) 1999, 2000, 2001, 2002 Networks Associates
 * Technology, Inc.  All rights reserved.
 * 
 * This file is part of LOMAC.
 *
 * LOMAC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * LOMAC is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOMAC; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 *************************************************************************/

#include "kernel_interface.h"

int mediate_subject_subject( const char *op_s,
			     const lomac_subject_t *p_subject_one, 
			     const lomac_subject_t *p_subject_two );
int mediate_subject_path( const char *op_s, const lomac_subject_t *p_subject,
			  const char *path_s );
int mediate_subject_object( const char *op_s, const lomac_subject_t *p_subject,
			    const lomac_object_t *p_object );
int mediate_path_path( const char *op_s, const lomac_subject_t *p_subject,
		       const char *canabsname_one_s, 
		       const char *canabsname_two_s );
int mediate_subject_subject( const char *op_s, 
			     const lomac_subject_t *p_subject,
			     const lomac_subject_t *p_target );
int mediate_subject_at_lattr( const char *op_s, 
			      const lomac_subject_t *p_subject,
			      const lattr_t target_lattr );
int mediate_object_at_lattr( const char *op_s,
			     const lomac_subject_t *p_subject,
			     const lomac_object_t *p_object,
			     const lattr_t target_lattr );

#endif
