#ifndef _LOMAC_MONITOR_H_
#define _LOMAC_MONITOR_H_

/*************************************************************************
 *
 * lomac_monitor.h
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux
 * Copyright (c) 1999, 2000, 2001, 2002 Networks Associates
 * Technology, Inc.  All rights reserved.
 * 
 * This file is part of LOMAC.
 *
 * LOMAC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * LOMAC is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOMAC; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 *************************************************************************/

#include "kernel_interface.h"

void monitor_open( lomac_subject_t *p_subject, lomac_object_t *p_object );
void monitor_read_object( lomac_subject_t *p_subject,
			  lomac_object_t *p_object );
void monitor_read_nic( lomac_subject_t *p_subject, lomac_nic_t *p_nic );
void monitor_pipe_create( lomac_subject_t *p_subject,
			  lomac_object_t *p_pipe );
void monitor_pipe_write( lomac_subject_t *p_subject, lomac_object_t *p_pipe );
void monitor_unix_socket_bind( lomac_subject_t *p_subject,
                               lomac_object_t *p_socket, 
			       lomac_object_t *p_name );
void monitor_unix_socket_abstract( lomac_subject_t *p_subject,
				   lomac_object_t *p_socket ); 
void monitor_unix_socketpair( lomac_subject_t *p_subject,
			      lomac_object_t *p_socket1,
			      lomac_object_t *p_socket2 ); 
void monitor_unix_socket_accept_connect( lomac_subject_t *p_subject,
					 lomac_object_t *p_old_socket,
					 lomac_object_t *p_new_socket );

#endif
