/**************************************************************************
 *
 * lomac_tpl.c
 *
 * LOMAC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * LOMAC is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOMAC; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 * This is the implementation of the Trusted Program List (TPL).  It
 * provides a list of programs that are "trusted".
 *
 *
 * ## I've included XFree86 in the TPL.  This is a hack.  XFree86 needs
 * to create /var/log/XFree86.n.log while running at level 1.  /var/log
 * is high, so the creat operation fails.  Annoying.
 *
 **************************************************************************/

#ifdef TRUST

#include "policy_tpl.h"
#include "lomac_tpl.h"


/* is_running_trusted_program()
 *
 * in:     p_subject - subject to query
 * out:    nothing
 * return: value    condition
 *         -----    ---------
 *           1      `p_subject' is running a program in the TPL.
 *           0      `p_subject' is not running a program in the TPL, or error.
 *
 *    This function is a predicate indicating whether or not the
 * process specified by `p_subject' is running a program that is
 * listed in the tpl.  It is not implemented very efficiently.
 *
 */ 

int is_running_trusted_program( lomac_subject_t *p_subject ) {

  int index = 0;               /* index into the `tpl' array */
  lomac_object_t *p_binary;    /* `p_subject' is running this binary */
  lomac_object_t *p_tp_binary; /* points to binaries of trusted programs */
  int ret_val = 0;             /* value to be returned by this function */

#ifdef PARANOID
  if( !p_subject ) {
    PANIC( "LOMAC: is_running_trusted_program() given null subject\n" );
  }
#endif

  /* Get object corresponding to `p_subject's binary. */
  if( !( p_binary = get_subject_program_object( p_subject ) ) ) {
    return( 0 );    /* error, report not running trusted program */
  }

  index = 0;        /* start with first entry in TPL */
  ret_val = 0;      /* pessimistically assume not running trusted program */
  while( ( index < NUM_TPL_ENTRIES ) && ( ret_val == 0 ) ) {
    if( ( p_tp_binary = path_to_object( tpl[ index ] ) ) ) {
      if( p_tp_binary == p_binary ) {
	ret_val = 1;  /* yes, `p_subject' is running a trusted program */
      }
      object_done( p_tp_binary );
    }
    index++;        /* move to next TPL entry */
  }

  object_done( p_binary );
  return( ret_val ); 

} /* is_running_trusted_program() */

#endif /* TRUST */
