#########################################################################
#
# LOMAC - Low Water-Mark Mandatory Access Control for Linux
# Copyright (c) 1999, 2000, 2001, 2002 Networks Associates
# Technology, Inc.  All rights reserved.
# 
# This file is part of LOMAC.
#
# LOMAC is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2, as
# published by the Free Software Foundation.
#
# LOMAC is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LOMAC; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# This module contains a number of common predicates that are useful
# to LOMAC test scripts.
#
# To use, put this in your Perl test script:
# use lomacpred;
#
#########################################################################

package lomacpred;   # I am package "lomacpred"
use Exporter ();     # I depend Exporter, but don't import any Exporter symbols
@ISA = qw(Exporter); # I'm an Exporter, and inherit Exporter's import() method
@EXPORT = (ProcAtLevelPred, FileAtLevelPred);  # I export these symbols


#########################################################################
#
# Subroutine ProcAtLevelPred
#
# Parms:
# $_[ 0 ]   level we expect to be at
#
# Return:   1 if we (that is, this process) is running at the level
#           indicated by $_[ 0 ], otherwise 0.
#
#########################################################################

sub ProcAtLevelPred {
        local($requested_level) = pop(@_);
        local($our_level);

        # Use the level program to determine our level.  $$ means our pid.
        open( LEVELOUT, "/opt/lomac/bin/lps $$|" );
	@lps_output = <LEVELOUT>;
	close( LEVELOUT );
	$level_line = $lps_output[ 1 ];
	@level_cols = split( ' ', $level_line );
	$our_level = $level_cols[ 1 ];

        return( $our_level == $requested_level );
}


#########################################################################
#
# Subroutine FileAtLevelPred
#
# Parms:
# $_[ 0 ]   filename whose level we want to check
# $_[ 1 ]   level we expect the file to be at
#
# Return:   1 if the file indicated by $_[ 0 ] is at the level
#           indicated by $_[ 1 ], otherwise 0.
#
#########################################################################

sub FileAtLevelPred {
	local($file_level) = pop(@_);
	local($filename) = pop(@_);
	local($level);

	# Use the level program to determine the file's level.
	open( LEVELOUT, "/opt/lomac/bin/lls $filename|" );
	$level_line = <LEVELOUT>;
	close( LEVELOUT );
	@level_cols = split( ' ', $level_line );
	$level = $level_cols[ 3 ];

	return( $level == $file_level );
}
