/*************************************************************************
 *
 * kernel_interface.c
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux
 * Copyright (c) 1999, 2000, 2001, 2002 Networks Associates
 * Technology, Inc.  All rights reserved.
 * 
 * This file is part of LOMAC.
 *
 * LOMAC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * LOMAC is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOMAC; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * fake kernel interface code to allow user-space testing.
 *
 *************************************************************************/

#include "kernel_interface.h"

#include <stdlib.h>
#include <stdio.h>


#define SUBJECT_NAME "<subject>"
#define SUBJECT_NAME_LEN 9

/* Some fake functions for convenience */

int  get_subject_id( lomac_subject_t *p_subject, char *id_s, int bufflen ) {
  if( bufflen >= SUBJECT_NAME_LEN ) {
    strncpy( id_s, SUBJECT_NAME, bufflen );
    return( SUBJECT_NAME_LEN );
  } else {
    return( 0 );
  }
}

#define OBJECT_NAME "<object>"
#define OBJECT_NAME_LEN 8

int  get_object_id( lomac_object_t *p_object, char *id_s, int bufflen ) {
  if( bufflen >= OBJECT_NAME_LEN ) {
    strncpy( id_s, OBJECT_NAME, bufflen );
    return( OBJECT_NAME_LEN );
  } else {
    return( 0 );
  }
}

void panic( char *s ) {
  printf( "%s", s );
  exit( -1 );
}

size_t strnlen( const char *s, int n ) {
  return( strlen( s ) );
}



