#ifndef _KERNEL_INTERFACE_H_
#define _KERNEL_INTERFACE_H_

/***************************************************************************
 *
 * kernel_interface.h
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux
 * Copyright (c) 1999, 2000, 2001, 2002 Networks Associates
 * Technology, Inc.  All rights reserved.
 * 
 * This file is part of LOMAC.
 *
 * LOMAC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * LOMAC is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOMAC; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *
 * This is a fake kernel interface to allow user-space testing.
 *
 *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>
#include <limits.h>

#include "lomac_level.h"


typedef void lomac_subject_t;

int  get_subject_id( lomac_subject_t *p_subject, char *id_s, int bufflen );


typedef void lomac_object_t;

int  get_object_id( lomac_object_t *p_object, char *id_s, int bufflen );


void panic( char *s );
size_t strnlen( const char *s, int n );



/* This macro must take a string arg and print it to stdout. */
#define LOG( str )( printf( "%s", (str) ) )

/* This macro must print a message to the system console *
 * and panic the kernel.                                 */
#define PANIC panic

/* These macro must present various libc str...(3) behaviors. */
#define STRCMP  strcmp
#define STRNCAT strncat
#define STRNLEN strnlen
#define STRSTR strstr

/* This macro must place the decimal ASCII representation of *
 * `data' into `ascii'.                                      */
#define TOASCII( data, ascii )( sprintf( (ascii), "%u", (data) ) )

/* MAX_DIGITS is a sufficient number of decimal digits to describe a *
 * 64-bit uint with a null terminator, rounded to a multiple of 8.   */
#define MAX_DIGITS 24 

/* MAX_PATH_LEN is the length of the longest possible path string, *
 * including the space for the null terminator.                    */
#define MAX_PATH_LEN PATH_MAX

/* LOG_BUFFER_LENGTH is a string length "large enough" to hold        *
 * interesting log messages.  You can set this to whatever you        *
 * want, the log routines will be careful not to exceed this limit.   *
 * Since some routines use log_s as scratch path space, this constant *
 * should always be at least MAX_PATH_LEN long.                       */
#define LOG_BUFFER_LENGTH MAX_PATH_LEN

#endif






