/*************************************************************************
 *
 * tester.c
 *
 * LOMAC - Low Water-Mark Mandatory Access Control for Linux
 * Copyright (c) 1999, 2000, 2001, 2002 Networks Associates
 * Technology, Inc.  All rights reserved.
 * 
 * This file is part of LOMAC.
 *
 * LOMAC is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2, as
 * published by the Free Software Foundation.
 *
 * LOMAC is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOMAC; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * This file contains the main program of a user-space PLM test utility.
 *
 *************************************************************************/

#include <stdio.h>

#include "lomac_level.h"
#include "lomac_plm.h"

int main( int argc, char *argv[] ) {

  level_t level;

  if( argc != 2 ) {
    fprintf( stderr, "USAGE: test_plm <path>\n" );
    exit( -1 );
  }

#ifdef PARANOID
  check_plm_constraints();
#endif

  get_pathname_level( argv[ 1 ], &level );

  printf( "%d\n", level );

  return( level );

} /* main() */

