//      ==========
module  f_function (R, key, P);
//      ==========
//
// this module does the "f" function for DES encryption
//

input  [31:0] R;      // the RHS half of the input
input  [47:0] key;    // the current (permuted) key
output [31:0] P;      // a resultant 32 bit value

wire   [31:0] R;
wire   [47:0] key;
wire   [31:0] P;

// the RHS is first permuted using the "E" function
// note that the bits in FIPS 46 are numbered 1..32
// and here we use 31:0

wire [47:0] E;
assign E[47:0] = { R[ 0], R[31], R[30], R[29], R[28], R[27],
                   R[28], R[27], R[26], R[25], R[24], R[23],
                   R[24], R[23], R[22], R[21], R[20], R[19],
                   R[20], R[19], R[18], R[17], R[16], R[15],
                   R[16], R[15], R[14], R[13], R[12], R[11],
                   R[12], R[11], R[10], R[ 9], R[ 8], R[ 7],
                   R[ 8], R[ 7], R[ 6], R[ 5], R[ 4], R[ 3],
                   R[ 4], R[ 3], R[ 2], R[ 1], R[ 0], R[31] };

// we now XOR E into the key

wire [47:0] KR;
assign KR = E ^ key;

// and then we use these values, six at a time, to select
// values from the SBOX arrays

wire [31:0] L;

sbox1 box1(KR[47:42], L[31:28]);
sbox2 box2(KR[41:36], L[27:24]);
sbox3 box3(KR[35:30], L[23:20]);
sbox4 box4(KR[29:24], L[19:16]);
sbox5 box5(KR[23:18], L[15:12]);
sbox6 box6(KR[17:12], L[11: 8]);
sbox7 box7(KR[11: 6], L[ 7: 4]);
sbox8 box8(KR[ 5: 0], L[ 3: 0]);

// the resultant value we call L (not to be confused with the LHS part of
// the input value) so correspond with the FIPS46 notation of P(L)
// we now construct the output value, again using 31:0 as the
// bit numbering (whereas FIPS46 uses 1..32)

assign P[31:0] = { L[16], L[25], L[12], L[11],
                   L[ 3], L[20], L[ 4], L[15],
                   L[31], L[17], L[ 9], L[ 6],
                   L[27], L[14], L[ 1], L[22],
                   L[30], L[24], L[ 8], L[18],
                   L[ 0], L[ 5], L[29], L[23],
                   L[13], L[19], L[ 2], L[26],
                   L[10], L[21], L[28], L[ 7] };

endmodule
