
/*
 * FILE:
 * gtkstripchartcursor.h
 *
 * FUNCTION:
 * GTK widget to draw a cursor 
 *
 * HISTORY:
 * Linas Vepstas February 2002
 */

#ifndef GTK_STRIP_CHART_CURSOR_H 
#define GTK_STRIP_CHART_CURSOR_H 

#include <time.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <gtkextra/gtkplotcanvas.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* ------------------------------------------------ */

#define GTK_TYPE_STRIP_CHART_CURSOR	(gtk_strip_chart_cursor_get_type())
#define GTK_STRIP_CHART_CURSOR(obj) 	(GTK_CHECK_CAST ((obj), GTK_TYPE_STRIP_CHART_CURSOR, GtkStripChartCursor))
#define GTK_STRIP_CHART_CURSOR_CLASS(klass) ((GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_STRIP_CHART_CURSOR, GtkStripChartCursorClass))

#define GTK_IS_STRIP_CHART_CURSOR(obj)	(GTK_CHECK_TYPE ((obj), GTK_TYPE_STRIP_CHART_CURSOR))
#define GTK_IS_STRIP_CHART_CURSOR_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_STRIP_CHART_CURSOR))

/* ------------------------------------------------ */

typedef struct _GtkStripChartCursor 	   GtkStripChartCursor;
typedef struct _GtkStripChartCursorClass 	GtkStripChartCursorClass;

typedef GList GtkStripChartCursorList;

struct _GtkStripChartCursor 
{
  GtkPlotData plot_data;
  gdouble x_position;

  GtkStripChartCursorList * drag_list; /* other cursors that drag with this one.  */

  /* private data do not touch */
  gdouble xpos[2];
  gdouble ypos[2];

  GtkPlot *strip;  /* parent strip */
};

struct _GtkStripChartCursorClass
{
  GtkPlotDataClass parent_class;
};



GtkType    gtk_strip_chart_cursor_get_type  (void);
GtkWidget  *gtk_strip_chart_cursor_new    (void);
void       gtk_strip_chart_cursor_set_pos (GtkStripChartCursor *, gdouble pos);
void       gtk_strip_chart_cursor_set_height (GtkStripChartCursor *, 
                                        gdouble ymin, gdouble ymax);

void       gtk_strip_chart_cursor_add_drag (GtkStripChartCursor *, 
                                            GtkStripChartCursor *);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GTK_STRIP_CHART_CURSOR_H */
