
/*
 * FILE:
 * gtkstripchartlimit.h
 *
 * FUNCTION:
 * GTK strip chart widget to display limit band 
 * (a band of y values that have thier own color)
 * Useful for setting alarm/warning bands, etc.)
 * Basically, everything *below* the limit line 
 * will be colored the indicated color.
 *
 * HISTORY:
 * Linas Vepstas February 2002
 */

#ifndef GTK_STRIP_CHART_LIMIT_H 
#define GTK_STRIP_CHART_LIMIT_H 

#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <gtkextra/gtkplotcanvas.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_STRIP_CHART_LIMIT	(gtk_strip_chart_limit_get_type())
#define GTK_STRIP_CHART_LIMIT(obj) 	(GTK_CHECK_CAST ((obj), GTK_TYPE_STRIP_CHART_LIMIT, GtkStripChartLimit))
#define GTK_STRIP_CHART_LIMIT_CLASS(klass) ((GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_STRIP_CHART_LIMIT, GtkStripChartLimitClass))

#define GTK_IS_STRIP_CHART_LIMIT(obj)	(GTK_CHECK_TYPE ((obj), GTK_TYPE_STRIP_CHART_LIMIT))
#define GTK_IS_STRIP_CHART_LIMIT_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_STRIP_CHART_LIMIT))

/* ------------------------------------------------ */

typedef struct _GtkStripChartLimit 		GtkStripChartLimit;
typedef struct _GtkStripChartLimitClass 	GtkStripChartLimitClass;

typedef GList GtkStripChartLimitList;

struct _GtkStripChartLimit
{
  GtkPlotData plot_data;

  GdkColor range_color;
  gdouble range_max;
  gint    range_fill;   /* whether to fill_area */

  gdouble line_x[2];  /* private data for drawing line */
  gdouble line_y[2];

};

struct _GtkStripChartLimitClass
{
  GtkPlotDataClass parent_class;
};


GtkType    gtk_strip_chart_limit_get_type  (void);
GtkWidget  *gtk_strip_chart_limit_new    (void);

void   gtk_strip_chart_limit_set_range (GtkStripChartLimit *limit, 
                                       gdouble range_limit);

void   gtk_strip_chart_limit_set_color (GtkStripChartLimit *limit, 
                                        GdkColor color);

void   gtk_strip_chart_limit_set_width (GtkStripChartLimit *limit, 
                                        gdouble xmin, gdouble xmax);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GTK_STRIP_CHART_LIMIT_H */
