
/*
 * FILE:
 * gtkstripchartstrip.h
 *
 * FUNCTION:
 * GTK widget that represents one strip on the strip chart.
 *
 * HISTORY:
 * Linas Vepstas February 2002
 */

#ifndef GTK_STRIP_CHART_STRIP_H 
#define GTK_STRIP_CHART_STRIP_H 

#include <time.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <gtkextra/gtkplotcanvas.h>

#include "gtkstripchartcursor.h"
#include "gtkstripchartlimit.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_STRIP_CHART_STRIP	(gtk_strip_chart_strip_get_type())
#define GTK_STRIP_CHART_STRIP(obj) 	(GTK_CHECK_CAST ((obj), GTK_TYPE_STRIP_CHART_STRIP, GtkStripChartStrip))
#define GTK_STRIP_CHART_STRIP_CLASS(klass) ((GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_STRIP_CHART_STRIP, GtkStripChartStripClass))

#define GTK_IS_STRIP_CHART_STRIP(obj)	(GTK_CHECK_TYPE ((obj), GTK_TYPE_STRIP_CHART_STRIP))
#define GTK_IS_STRIP_CHART_STRIP_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_STRIP_CHART_STRIP))

/* ------------------------------------------------ */

typedef struct _GtkStripChartStrip 	GtkStripChartStrip;
typedef struct _GtkStripChartStripClass 	GtkStripChartStripClass;

typedef GList GtkStripChartStripList;
typedef GList GtkPlotDataList;

struct _GtkStripChartStrip  
{
  GtkPlot plot;

  /* data to graph */
  int npts;
  gdouble *xpts;
  gdouble *ypts;

  /* line attributes to use: set/over-ride as desired */
  GtkPlotSymbol      symbol;
  GtkPlotLine        line_attrs;
  GtkPlotConnector   line_connector;
  gboolean           override_symbol_color;
  gboolean           override_symbol_border_color;

  /* y-value limit bands by which which to color the data */
  /* (organized by ascending y value) */
  GtkStripChartLimitList *limit_list;

  // draggable cursor
  GtkStripChartCursorList *curs_list;

  // private data: what is actually plotted.
  GtkPlotDataList *plot_data_list;

  // private data: plot stubs
  GList *stubs;
};

struct _GtkStripChartStripClass
{
  GtkPlotClass parent_class;

};


GtkType    gtk_strip_chart_strip_get_type  (void);
GtkWidget  *gtk_strip_chart_strip_new    (void);

void        gtk_strip_chart_strip_set_xrange (GtkStripChartStrip *chart,
                                           gdouble xmin, gdouble xmax);

void        gtk_strip_chart_strip_set_yrange (GtkStripChartStrip *chart,
                                           gdouble ymin, gdouble ymax);

void       gtk_strip_chart_strip_add_cursor (GtkStripChartStrip *, 
                                             GtkStripChartCursor *);

void       gtk_strip_chart_strip_add_limit (GtkStripChartStrip *, 
                                            GtkStripChartLimit *);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GTK_STRIP_CHART_STRIP_H */
