
/*
 * FILE:
 * gtkstripchartchart.h
 *
 * FUNCTION:
 * GTK widget to display multiple strip charts, and operate 
 * on them in unison.
 *
 * To zoom/scroll, use the keyboard arrow keys.
 *
 * HISTORY:
 * Linas Vepstas February 2002
 */

#ifndef GTK_STRIP_CHART_CHART_H 
#define GTK_STRIP_CHART_CHART_H 

#include <gtk/gtk.h>
#include <gtkextra/gtkplot.h>
#include <gtkextra/gtkplotcanvas.h>

#include "gtkstripchartcursorset.h"
#include "gtkstripchartlimit.h"
#include "gtkstripchartstrip.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define GTK_TYPE_STRIP_CHART_CHART	(gtk_strip_chart_chart_get_type())
#define GTK_STRIP_CHART_CHART(obj) 	(GTK_CHECK_CAST ((obj), GTK_TYPE_STRIP_CHART_CHART, GtkStripChartChart))
#define GTK_STRIP_CHART_CHART_CLASS(klass) ((GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_STRIP_CHART_CHART, GtkStripChartClass))

#define GTK_IS_STRIP_CHART_CHART(obj)	(GTK_CHECK_TYPE ((obj), GTK_TYPE_STRIP_CHART_CHART))
#define GTK_IS_STRIP_CHART_CHART_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_STRIP_CHART_CHART))

/* ------------------------------------------------ */

typedef struct _GtkStripChartChart 		GtkStripChartChart;
typedef struct _GtkStripChartChartClass 	GtkStripChartChartClass;


struct _GtkStripChartChart
{
  GtkPlotCanvas plot_canvas;  /* inherits from gtkFixed, from gtkContainer */

  /* collection of individual strips */
  GtkStripChartStripList *strip_list;

  /* all cursors sets in this chart */
  GtkStripChartCursorSetList *cursor_set_list;

  GtkStripChartCursor *drag_curs;  /* cursor being currently dragged */

  /* min and max x range of displayed data */
  gdouble chart_min;
  gdouble  chart_max;

  /* min and max y range of displayed data */
  gdouble range_min;
  gdouble  range_max;

  /* color used when no limits are effective */
  GdkColor default_color;

  /* line attributes to use for drawing strips */
  GtkPlotSymbol      symbol;
  GtkPlotLine        line_attrs;
  GtkPlotConnector   line_connector;
  gboolean           override_symbol_color;
  gboolean           override_symbol_border_color;

  char * title;       /* title for the whole strip chart */
  char * ylabel;      /* prefix to the chart number */

  gint  left_pixel_margin;   /* offset to plot in pixels */
  gint  right_pixel_margin;  /* offset to plot in pixels */
  gint  top_pixel_margin;    /* offset to plot in pixels */
  gint  bottom_pixel_margin; /* offset to plot in pixels */
  gint  left_title_offset;   /* in pixels */
  gint  strip_separation_pixels; /* separation between strips (in y direction) */

  gint x_label_spacing;    /* distance between x-axis ticks & labels (in pixels)*/
  gint y_label_spacing;    /* distance between y-axis ticks (in pixels) */
  gint use_date_labels;    /* label type on the x-axis */

  /* private data; do not touch */
  /* this is actually a hack for widget resizing */
  guint16 ow, oh;

  int nx_ticks;      /* private, cached */
  int strip_height;  /* private, cached (in pixels) */
};

struct _GtkStripChartChartClass
{
  GtkPlotCanvasClass parent_class;

  void (*cursor_select)(GtkStripChartChart *chart, GtkStripChartCursor *dragee);
  void (*cursor_drag)  (GtkStripChartChart *chart, GtkStripChartCursor *dragee);

};


GtkType    gtk_strip_chart_chart_get_type  (void);
GtkWidget  *gtk_strip_chart_chart_new    (void);

GtkPlot    *gtk_strip_chart_chart_add_strip (GtkStripChartChart *chart, 
                                      int npts, gdouble *x, gdouble *y);

// set the vertical range
void   gtk_strip_chart_chart_set_range (GtkStripChartChart *chart, 
                                  gdouble ymin, gdouble ymax);

// Set the vertical range to the min & max in the dataset
void   gtk_strip_chart_chart_auto_range (GtkStripChartChart *chart);

// set default color to use when no limit lines are specified
void   gtk_strip_chart_chart_set_color (GtkStripChartChart *chart, 
                                        GdkColor color);

// set the horizontal range
void   gtk_strip_chart_chart_set_xrange (GtkStripChartChart *chart, 
                                   gdouble xmin, gdouble xmax);

// set the horizontal range to the min & max of all the datasets 
void   gtk_strip_chart_chart_auto_xrange (GtkStripChartChart *chart);

// create limit lines on each of the strips
void   gtk_strip_chart_chart_add_limit (GtkStripChartChart *chart, 
                                  gdouble lim,
                                  GdkColor color);

// create and add a cursor on each of the strips
GtkStripChartCursorSet * gtk_strip_chart_chart_add_cursor (
                                   GtkStripChartChart *chart, 
                                   GdkColor *color, gdouble x_position,
                                   gboolean draggable, gint style);

// redraw, typically because the data has changed
void   gtk_strip_chart_chart_redraw (GtkStripChartChart *chart);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GTK_STRIP_CHART_CHART_H */
