
/*
 * FILE:
 * gtkstripchartcursorset.h
 *
 * FUNCTION:
 * GTK widget that is a collection of cursor_sets.
 *
 * HISTORY:
 * Linas Vepstas February 2002
 */

#ifndef GTK_STRIP_CHART_CURSOR_SET_H 
#define GTK_STRIP_CHART_CURSOR_SET_H 

#include <time.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include <gtkextra/gtkplotcanvas.h>

#include "gtkstripchartcursor.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* ------------------------------------------------ */

#define GTK_TYPE_STRIP_CHART_CURSOR_SET	(gtk_strip_chart_cursor_set_get_type())
#define GTK_STRIP_CHART_CURSOR_SET(obj) 	(GTK_CHECK_CAST ((obj), GTK_TYPE_STRIP_CHART_CURSOR_SET, GtkStripChartCursorSet))
#define GTK_STRIP_CHART_CURSOR_SET_CLASS(klass) ((GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_STRIP_CHART_CURSOR_SET, GtkStripChartCursorSetClass))

#define GTK_IS_STRIP_CHART_CURSOR_SET(obj)	(GTK_CHECK_TYPE ((obj), GTK_TYPE_STRIP_CHART_CURSOR_SET))
#define GTK_IS_STRIP_CHART_CURSOR_SET_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_STRIP_CHART_CURSOR_SET))

/* ------------------------------------------------ */

typedef GList GtkStripChartCursorSetList;

struct _GtkStripChartCursorSet 
{
  GtkPlotData plot_data;

  gdouble   x_position;
  gboolean  dragable;

  GtkStripChartCursorList * drag_list; /* other cursors that drag with this one.  */

};

struct _GtkStripChartCursorSetClass
{
  GtkPlotDataClass parent_class;
};


GtkType    gtk_strip_chart_cursor_set_get_type  (void);
GtkWidget *gtk_strip_chart_cursor_set_new    (void);

/* add a cursor to the set */
void       gtk_strip_chart_cursor_set_add_cursor (GtkStripChartCursorSet *, 
                                            GtkStripChartCursor *);

/* set the position 
 * Sets the postion for all cursors in this set.
 */
void       gtk_strip_chart_cursor_set_set_pos (GtkStripChartCursorSet *, 
                                               gdouble pos);


/* set the height 
 * Sets the height for all cursors in this set.
 */
void       gtk_strip_chart_cursor_set_set_height (GtkStripChartCursorSet *, 
                                        gdouble ymin, gdouble ymax);
/* mark the set as draggable or not.
 * Sets the dragable boolean for all cursors in this set.
 */

void      gtk_strip_chart_cursor_set_set_dragable (GtkStripChartCursorSet *, 
                                        gboolean dragable);

/* same as gtk_plot_data_set_symbol() except that it affects all cursors */
void      gtk_strip_chart_cursor_set_set_symbol (GtkStripChartCursorSet *, 
                                                 GtkPlotSymbolType type,
                                                 GtkPlotSymbolStyle style,
                                                 gint size,
                                                 gfloat line_width,
                                                 const GdkColor *color,
                                                 const GdkColor *border_color);


#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* GTK_STRIP_CHART_CURSOR_SET_H */
